<?php
/**
 * Blog card template.
 *
 * Renders a single blog post card; expects global $post.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$img  = get_the_post_thumbnail_url( get_the_ID(), 'large' );
$tags = get_the_terms( get_the_ID(), 'post_tag' );
?>

<article class="blog-card">

	<?php if ( $img ) : ?>
		<a href="<?php the_permalink(); ?>" class="blog-card__image">
			<img src="<?= esc_url( $img ); ?>" alt="<?php the_title_attribute(); ?>" loading="lazy">
		</a>
	<?php endif; ?>

	<div class="blog-card__meta">
		<?php if ( $tags && ! is_wp_error( $tags ) ) : ?>
			<?php foreach ( $tags as $tag ) : ?>
				<span class="blog-card__tag"><?= esc_html( $tag->name ); ?></span>
			<?php endforeach; ?>
		<?php endif; ?>

		<span class="blog-card__date"><?= esc_html( get_the_date( 'F j, Y' ) ); ?></span>
	</div>

	<h3 class="blog-card__title">
		<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
	</h3>

	<p class="blog-card__excerpt">
		<?= esc_html( wp_trim_words( get_the_excerpt(), 50 ) ); ?>
	</p>

	<a href="<?php the_permalink(); ?>" class="blog-card__more">Learn more</a>

</article>
