jQuery(function ($) {

  $.smoothScrollTo = function (target, options) {
      const settings = $.extend({
          offset: 0,
          behavior: 'smooth'
      }, options);

      let top;
      if (typeof target === 'number') {
          top = target;
      } else {
          const $el = typeof target === 'string' ? $(target) : $(target);
          if ($el.length === 0) return;

          const rect = $el[0].getBoundingClientRect();
          top = Math.round(window.pageYOffset + rect.top);
      }

      top += settings.offset;

      $('.js-mobileMenu').removeClass('open');

      window.scrollTo({ top, behavior: settings.behavior });
  };

});
