// STYLES
import './main/scss/app.scss';
import './main/scss/blog-single.scss';
import './../blocks/contact-from/contact-from.scss';

// JS
import './main/js/nav';
import './main/js/SmoothScroll';
import './main/js/popup';

jQuery(function ($) {

console.log("Blog - single");

    const $content = $('.js-entryContent');
    const $toc = $('.js-onThisPage');

    if (!$content.length || !$toc.length) return;

    const $headings = $content.find('h2');
    if (!$headings.length) return;

    const $ul = $('<ul class="d-flex flex-column"></ul>');
    const usedIds = {};

    $headings.each(function (index) {
        const $h2 = $(this);
        let text = $.trim($h2.text());
        if (!text) text = 'Section ' + (index + 1);

        // Generate safe ID
        let id = $h2.attr('id');
        if (!id) {
            id = text
                .toLowerCase()
                .trim()
                .replace(/[\s]+/g, '-')
                .replace(/[^a-z0-9\-\u0400-\u04FF]/g, ''); // allow latin + cyrillic + dash
        }

        // Ensure unique id
        let uniqueId = id;
        let counter = 2;
        while (usedIds[uniqueId] || $('#' + uniqueId).length) {
            uniqueId = id + '-' + counter;
            counter++;
        }
        usedIds[uniqueId] = true;
        $h2.attr('id', uniqueId);

        // Create link
        const $a = $('<a></a>')
            .attr('href', '#' + uniqueId)
            .addClass('on-this-page-link')
            .text(text);

        const $li = $('<li></li>').append($a);
        $ul.append($li);
    });

    $toc.append($ul);

    // Try to detect fixed header height (customize selector if needed)
    function getHeaderOffset() {
        var $hdr = $('.site-header, .header, #header').first();
        return $hdr.length ? $hdr.outerHeight() : 0;
    }


    // Optional: handle initial load with hash (apply offset instead of native jump)
    $(function(){
        var hash = window.location.hash;
        if (hash && $(hash).length) {
        // Delay to allow layout/images to settle
        setTimeout(function(){
            var headerOffset = getHeaderOffset();
            var top = Math.max(0, $(hash).offset().top - headerOffset - 8);
            $(window).scrollTop(top);
        }, 0);
        }
    });
    // ---- Highlight active heading while scrolling ----
    const $links = $toc.find('a.on-this-page-link');

    jQuery(window).on('scroll', function () {
        let scrollPos = jQuery(window).scrollTop() + 100; // add small offset
        let currentId = null;

        $headings.each(function () {
            const top = jQuery(this).offset().top;
            if (scrollPos >= top) {
                currentId = this.id;
            }
        });

        if (currentId) {
            $links.removeClass('active');
            $links.filter('[href="#' + currentId + '"]').addClass('active');
        }
    });

});