<?php

if (! defined('ABSPATH')) {
  exit;
}

use Headless\Utils\CommonUtils;

$head_code         = get_field('head_code',       'option');
$code_start_body   = get_field('code_start_body', 'option');
$logo              = get_field('logo',            'option');

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
  <!-- Preconnect to Google Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin>
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link rel="preconnect" href="https://www.google-analytics.com" crossorigin>
  <!-- END Preconnect to Google Fonts -->
  <meta http-equiv="Content-type" content="text/html; charset=<?php bloginfo('charset'); ?>">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="theme-color" content="#0069bd">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <?php wp_head(); ?>
  <?php if ($head_code) echo $head_code; ?>
</head>

<body style="transition: none!important;" <?php body_class(); ?>>
  <?php if ($code_start_body) echo $code_start_body; ?>

  <nav class="nav">

    <div class="container">

      <?php if ($logo): ?>
        <a href="/" class="logo" tabindex="0"> <?= CommonUtils::render_image_acf($logo, ['width' => 220, 'height' => 44, 'alt' => "Site logo"]) ?> </a>
      <?php endif; ?>

      <div class="mobile-menu js-mobileMenu">
        <?php
          wp_nav_menu([
            'theme_location' => 'primary',
            'menu_class'     => 'd-flex flex-column main-menu flex-md-row'
          ]);
        ?>
        <svg class="js-mobileMenuClose mobile-menu-close d-block d-md-none" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path d="M15 9L9 15M9 9L15 15M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z" stroke="#131314" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
        </svg>
      </div>

      <div class="burger js-burger d-flex flex-column d-md-none" role="button" tabindex="0" aria-label="Toggle menu">
        <span></span>
        <span></span>
        <span></span>
      </div>

    </div>

  </nav>