<?php

if (! defined('ABSPATH')) {
  exit;
}

use Headless\Utils\CommonUtils;

$logo                   = get_field('footer_logo',             'option');
$contact_list           = get_field('contact_list',            'option');
$social_networks        = get_field('social_networks',         'option');
$soc_list_title_footer  = get_field('soc_list_title_footer',   'option');
$soc_nav_footer         = get_field('soc_nav_footer',          'option');
$code_end_body          = get_field('code_end_body',           'option');
$copyright              = get_field('copyright',               'option');
$form_id                = get_field('form_id',                 'option');
$logos_html             = get_field('logos_html',              'option');

?>

<div class="popup">
  <?php if($form_id): ?>
    <div class="contact-from__main">
      <?= do_shortcode('[contact-form-7 id="'.$form_id.'"]') ?>
      <svg class="js-popupClose contact-from__close" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M15 9L9 15M9 9L15 15M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z" stroke="#131314" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      </svg>
    </div>
  <?php endif; ?>
</div>

<div class="overlay js-popupClose"></div>

<footer class="footer">
  
  <div class="container d-flex flex-column align-items-start">

    <?php if($logo): ?>
      <a href="/" tabindex="0" class="footer-logo"> <?= CommonUtils::render_image_acf( $logo, [ 'width' => 220, 'height' => 44, 'alt' => "Site logo" ] ) ?> </a>
    <?php endif; ?>

    <div class="footer-content d-flex flex-wrap">
      <?php if($contact_list && is_array($contact_list)): ?>
        <div class="footer-content__info">
          <?php foreach ($contact_list as $info): ?>
            <div class="footer-content__info__item">
              <?php if(isset($info['address']) && !empty($info['address'])): ?>
                <p class="footer__title paragraph"><?=$info['address']?></p>
              <?php endif; ?>
              <?php if(isset($info['email']) && !empty($info['email'])): ?>
                <p class="footer-content__info__email paragraph">
                  <img src="<?=RESOURCES_URL?>/main/imgs/footer/mail.svg" alt="mail icon" width="24" height="24" /> <?=__('Email', 'baltum')?>: <a href="mailto:<?=$info['email']?>" target="_blank"><?=$info['email']?></a>
                </p>
              <?php endif; ?>
              <?php if(isset($info['phone_number']) && !empty($info['phone_number'])): ?>
                <p class="footer-content__info__phone paragraph">
                  <img src="<?=RESOURCES_URL?>/main/imgs/footer/telephone.svg" alt="telephone icon" width="24" height="24" /> <?=__('Phone number', 'baltum')?>: <a href="tel:<?=$info['phone_number']?>" target="_blank"><?=$info['phone_number']?></a>
                </p>
              <?php endif; ?>
            </div>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
      <?php
        if (has_nav_menu('footer')) {
          wp_nav_menu(array(
              'theme_location'  => 'footer',
              'menu_class'      => 'nav-footer d-flex flex-wrap',
              'container_class' => 'nav-footer-list',
          ));
        }
      ?>
    </div>    
    <?php if($logos_html && is_array($logos_html)): ?>
      <div class="footer__logos align-items-center d-grid flex-wrap">
        <?php foreach($logos_html as $logo_item):
            if(isset($logo_item['item'])): ?>
            <div class="footer__logos__item d-flex align-items-center justify-content-center"><?=$logo_item['item']?></div>
        <?php endif; endforeach; ?>
      </div>
    <?php endif; ?>
    <?php if($copyright): ?>
      <div class="footer__copyright text-center"><?=$copyright?></div>
    <?php endif; ?>

  </div>
   
</footer>

<?php 
  wp_footer();
  if ($code_end_body) echo $code_end_body;
?>

</body>

</html>