<?php

use Headless\Utils\CommonUtils;

$id               = get_field('block_id');
$header_icon      = get_field('header_icon');
$block_title      = get_field('title');
$block_text       = get_field('text');
$list             = get_field('list');

?>

<section class="our-customers" <?php if (!empty($id)) echo "id='{$id}'"; ?>>
    <div class="container">

        <div class="our-customers__top">
            <?php if(!empty($block_title)): ?>
                <div class="section-header d-flex">
                    <?= CommonUtils::render_image_acf($header_icon, [ 'width' => 24, 'height' => 24, 'alt' => 'Section icon' ]); ?>
                    <?=$block_title?>
                </div>
            <?php endif; ?>
            
            <?php if(!empty($block_text)): ?>
                <div class="our-customers__text"><?=$block_text?></div>
            <?php endif; ?>
        </div>

        <?php if(!empty($list) && is_array($list)): ?>
            <div class="our-customers__list">
                <?php foreach($list as $item): ?>
                    <div class="our-customers__item d-flex flex-column align-center">
                        <?php if(!empty($item)){
                            echo CommonUtils::render_image_acf($item, [ 'width' => 110, 'height' => 48, 'alt' => 'Customer icon' ]);
                        } ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

    </div>
</section>
