<?php
    use Headless\Utils\CommonUtils;

    $id             = get_field('block_id');    
    $header_icon    = get_field('header_icon');
    $block_title    = get_field('title');
    $main_top_text  = get_field('main_top_text');
    $bottom_text    = get_field('bottom_text');
    $column_two     = get_field('column_two');
    $top_text       = get_field('top_text');
    $up_btn_text    = get_field('up_btn_text');    
    $block_link     = get_field('button');

?>

<section class="online-course" <?php if (!empty($id)) echo "id='{$id}'"; ?>>

    <div class="container">
        <?php if(!empty($block_title)): ?>
            <div class="section-header d-flex">
                <?= CommonUtils::render_image_acf($header_icon, [ 'width' => 24, 'height' => 24, 'alt' => 'header block icon', 'class' => 'why-us__icon' ]); ?>
                <?=$block_title?>
            </div>
        <?php endif; ?>

        <div class="online-course__content d-grid">
            <div class="online-course__1 d-flex flex-column justify-content-between">
                <div class="online-course__1__main-top-text"><?php if (!empty($main_top_text)) echo $main_top_text; ?></div>
                <div class="online-course__1__bottom-text"><?php if (!empty($bottom_text)) echo $bottom_text; ?></div>
            </div>
            <div class="online-course__2">
                <?php
                    if(isset($column_two)){
                        echo CommonUtils::render_image_acf($column_two, [ 'width' => 453, 'height' => 679, 'alt' => esc_html($block_title).' image' ]);
                    }
                ?>
            </div>
            <div class="online-course__3 d-flex flex-column justify-content-between">
                <div class="online-course__3__top-text"><?php if (!empty($top_text)) echo $top_text; ?></div>
                <div class="online-course__btn">
                    <div class="online-course__btn__text"><?php if (!empty($up_btn_text)) echo $up_btn_text; ?></div>
                    <?php if (!empty($block_link)) : $block_link['classes'] = ['btn', 'btn-white']; ?>
                        <?= CommonUtils::render_link( $block_link ) ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

</section>