<?php
use Headless\Utils\CommonUtils;

$id             = get_field('block_id');
$block_title    = get_field('hero_title');
$block_text     = get_field('text');
$list           = get_field('list');
$button_up_text = get_field('button_up_text');
$block_link     = get_field('button');
$image          = get_field('image');

?>

<section class="certification-hero" <?php if ($id) echo "id='{$id}'"; ?>>
    <div class="container">

        <?php if ($block_title) : ?>
            <h1 tabindex="0"><?= esc_html($block_title); ?></h1>
        <?php endif; ?>

        <div class="certification-hero__content d-grid">

            <?php if ($block_text) : ?>
                <h2 class="certification-hero__text" tabindex="0">
                    <?= $block_text; ?>
                </h2>
            <?php endif; ?>

            <?php if (!empty($list) && is_array($list)) : ?>
                <div class="certification-hero__list d-grid">
                    <?php foreach ($list as $item) : ?>
                        <?php if (!empty($item['text'])) : ?>
                            <div class="certification-hero__list__item" tabindex="0">
                                <?= esc_html($item['text']); ?>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <div class="certification-hero__btn d-flex flex-column justify-content-end">

                <?php if ($button_up_text) : ?>
                    <div class="certification-hero__button-up-text" tabindex="0">
                        <?= $button_up_text; ?>
                    </div>
                <?php endif; ?>

                <?php 
                if (!empty($block_link)) {
                    $block_link['classes'] = ['btn'];
                    echo CommonUtils::render_link($block_link);
                }
                ?>
            </div>

            <?php if ($image) : ?>
                <div class="certification-hero__image">
                    <?= CommonUtils::render_image_acf(
                        $image,
                        [
                            'width'  => 453,
                            'height' => 479,
                            'alt'    => 'Certification hero image'
                        ]
                    ); ?>
                </div>
            <?php endif; ?>

        </div>

    </div>
</section>
