<?php
/**
 * @param array $block The block settings and attributes.
 * @param string $content The block inner HTML (empty).
 * @param bool $is_preview True during backend preview render.
 * @param int $post_id The post ID the block is rendering content against.
 * @param array $context The context provided to the block by the post or its parent block.
 */

use Headless\Utils\Block\BlogArticleUtils;
use Headless\Utils\GraphQLBlockUtils;

if ( ! defined( 'WPINC' ) ) {
	die; // Prevent direct access
}

// Get all the fields for the block
$fields = get_fields();
if ( ! $fields ) {
	$fields = [];
}

// Define the allowed block types.
$allowed_blocks = [
	'core/heading',
	'core/paragraph',
	'core/image',
	'core/list',
	'core/list-item',
	'core/footnotes'
];

// Author
$author_id    = ! empty( $fields['blog_author'] ) ? $fields['blog_author'] : null;
$author_array = BlogArticleUtils::get_author_array( $author_id );
$author_html  = BlogArticleUtils::get_author_html( $author_array );

// Categories
$categories_ids   = ! empty( $fields['blog_categories'] ) ? $fields['blog_categories'] : null;
$categories_array = BlogArticleUtils::get_categories_array( $categories_ids );
$categories_html  = BlogArticleUtils::get_categories_html( $categories_array );

$related_posts_array = BlogArticleUtils::get_related_posts_array( $fields, $post_id );



include 'template.php';
?>