<?php

use Headless\Utils\CommonUtils;

$id             = get_field('block_id');
$header_icon    = get_field('header_icon');
$block_title    = get_field('title');
$list           = get_field('list');
$cards          = get_field('cards');
$block_link     = get_field('button');
?>

<section class="standards" <?php if (!empty($id)) echo "id='{$id}'"; ?>>
    <div class="container">
        <?php if(!empty($block_title)): ?>
            <div class="section-header d-flex">
                <?= CommonUtils::render_image_acf($header_icon, [ 'width' => 24, 'height' => 24, 'alt' => 'Section icon', 'class' => 'about__icon' ]); ?>
                <?=$block_title?>
            </div>
        <?php endif; ?>
        <div class="standards__content d-grid">
            <?php if(!empty($list) && is_array($list)): ?>
                <div class="standards__list align-self-start d-grid">
                    <?php foreach($list as $item): ?>
                        <div class="standards__list__item">
                            <?php if(isset($item['title'])): ?>
                                <p class="standards__list__title section-header"><?=$item['title']?></p>
                            <?php endif; ?>
                            <?php if(isset($item['text'])): ?>
                                <p class="standards__list__text"><?=$item['text']?></p>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            
            <?php if(!empty($cards) && is_array($cards)): ?>
                <div class="standards__cards d-grid">
                    <?php foreach($cards as $card): ?>
                        <div class="standards__cards__item d-flex flex-column justify-content-between <?php echo $card['card_width']; ?>">
                            <?php if(isset($card['icon'])){
                                echo CommonUtils::render_image_acf($card['icon'], [ 'width' => 24, 'height' => 24, 'alt' => 'Card icon', 'class' => 'standards__cards__icon' ]);
                            } ?>
                            <?php if(isset($card['title'])): ?>
                                <p class="standards__cards__title section-header"><?=$card['title']?></p>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                    <?php if (!empty($block_link)) : $block_link['classes'] = ['btn']; ?>
                        <div class="standards__cta d-flex align-items-end">
                            <?= CommonUtils::render_link( $block_link ) ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
