import metadata from "./block.json";
import './slider-standards.scss';
// Slick
import 'slick-carousel'
import 'slick-carousel/slick/slick.scss'

(function($) {
  function calculateSpeed(totalSlides) {
    const baseSpeed = 6000;
    const speedFactor = 1000;
    return baseSpeed + (7 - totalSlides) * speedFactor;
  }

  const initSlick = function($carousel) {
    if (typeof $.fn.slick !== 'function') {
      console.warn('Slick not available for slider-standards');
      return;
    }

    const totalSlides = $carousel.children().length;
    if (totalSlides < 1) return;

    const calculatedSpeed = totalSlides < 8 ? calculateSpeed(totalSlides) : 6000;
    const slidesToShow = Math.max(1, Math.min(totalSlides - 1, 8));

    if (!$carousel.hasClass('slick-initialized')) {
      $carousel.slick({
        infinite: true,
        slidesToShow,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 1,
        speed: calculatedSpeed,
        cssEase: 'linear',
        arrows: false,
        dots: false,
        pauseOnFocus: false,
        pauseOnHover: false,
        rows: false,
        responsive: [
          {
            breakpoint: 1600,
            settings: {
              slidesToShow: Math.max(1, Math.min(totalSlides - 1, 5)),
            },
          },
          {
            breakpoint: 1200,
            settings: {
              slidesToShow: Math.max(1, Math.min(totalSlides - 1, 4)),
            },
          },
          {
            breakpoint: 768,
            settings: {
              slidesToShow: Math.max(1, Math.min(totalSlides - 1, 3)),
            },
          },
          {
            breakpoint: 480,
            settings: {
              slidesToShow: Math.max(1, Math.min(totalSlides - 1, 3)),
            },
          },
        ],
      });

      setTimeout(function() {
        $carousel.slick('setPosition');
      }, 50);
    }
  };

  const initBlock = ($root) => {
    const $carousels = $root.find('.slider-standards__carousel');
    $carousels.each(function() {
      initSlick($(this));
    });
  };

  if (window.acf) {
    acf.addAction('render_block_preview/type=' + metadata.name, initBlock);
  }

  $(function() {
    initBlock($(document));
  });
})(jQuery);
