<?php

use Headless\Utils\CommonUtils;

$id             = get_field('block_id');
$header_icon    = get_field('header_icon');
$block_title    = get_field('title');
$list           = get_field('partners_list');
$text           = get_field('text');

$list_count    = is_array($list) ? count($list) : 0;
$special_class = $list_count >= 5 ? "special" : "" ;

?>

<section class="our-partners" <?php if (!empty($id)) echo "id='{$id}'"; ?>>
    <div class="container">
        <?php if(!empty($block_title)): ?>
            <div class="section-header d-flex">
                <?= CommonUtils::render_image_acf($header_icon, [ 'width' => 24, 'height' => 24, 'alt' => 'Section icon' ]); ?>
                <?=$block_title?>
            </div>
        <?php endif; ?>
    </div>

    <div class="container">
        <div class="our-partners__content d-md-grid <?=$special_class?>">
            <?php $text_order = 9999; if(!empty($list) && is_array($list)): ?>
                <div class="our-partners__cards js-ourPartnersCards">
                    <?php foreach($list as $i => $card): if($list_count - 1 == $i) {$text_order = $i; $i++;} ?>

                        <div class="our-partners__item js-ourPartnersItem" style="order: <?=$i?>">
                            <?php if(isset($card['logo'])) echo CommonUtils::render_image_acf($card['logo'], [ 'width' => 69, 'height' => 80, 'alt' => 'Partner logo', 'class' => 'our-partners__logo' ]); ?>
                            <?php if(isset($card['text'])): ?>
                                <p class="our-partners__text"><?=$card['text']?></p>
                            <?php endif; ?>
                        </div>
                        
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <?php if(!empty($text)): ?>
                <div class="our-partners__item__text d-flex" style="order: <?=$text_order?>"><p><?=$text?></p></div>
            <?php endif; ?>
        </div>
    </div>
</section>
