import {select, subscribe, dispatch} from '@wordpress/data';

/**
 * Sync featured image
 * @param {string} containerElem DOM element selector
 */
export default function syncFeaturedImage(containerElem) {
    let prevMediaId = null;

    subscribe(() => {
        const featuredMediaId = select('core/editor').getEditedPostAttribute('featured_media');
        if (containerElem && featuredMediaId && featuredMediaId !== prevMediaId) {
            prevMediaId = featuredMediaId;

            const media = select('core').getMedia(featuredMediaId);

            if (media && media.source_url) {
                containerElem.innerHTML = `<img src="${media.source_url}" alt="${media.alt || ''}" />`;
            } else {
                wp.apiFetch({
                    path: `/wp/v2/media/${featuredMediaId}`
                }).then((media) => {
                    if (media && media.source_url) {
                        containerElem.innerHTML = `<img src="${media.source_url}" alt="${media.alt || ''}" />`;
                    }
                });
            }
        }
    });
}