import metadata from "./block.json";
import syncH1WithPostTitle from './sync-h1-with-post-title';
import syncDate from './sync-date';
import syncFeaturedImage from './sync-featured-image';
import './editor.scss';

acf.addAction('render_block_preview/type=' + metadata.name, (block) => {
    const heading = block[0]?.querySelector('h1');
    if (heading) {
        syncH1WithPostTitle(heading);
    }

    const date = block[0]?.querySelector('.date');
    if (date) {
        syncDate(date);
    }

    const featuredImg = block[0]?.querySelector('.blog-article-img');
    if (featuredImg) {
        syncFeaturedImage(featuredImg);
    }
});
