<?php

declare( strict_types=1 );

namespace Headless\Modules\Patterns;

use Headless\Interfaces\Registrable;
use Headless\Traits\Loadable;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class PatternsManager
 *
 * Handles the management of Gutenberg patterns in the WordPress theme
 */

class PatternsManager implements Registrable {

	use Loadable;

	/**
	 * Register the patterns manager
	 *
	 * @return void
	 */
	public function register(): void {
		// Disable core block patterns
		add_action(
			'after_setup_theme',
			/**
			 * Disable core block patterns
			 *
			 * @return void
			 */
			function () {
				remove_theme_support( 'core-block-patterns' );
			}
		);

		// Disable remote block patterns
		add_filter(
			'should_load_remote_block_patterns',
			/**
			 * Disable remote block patterns
			 *
			 * @return bool
			 */
			static function () {
				return false;
			}
		);
	}

}

PatternsManager::load();