<?php
declare( strict_types=1 );

namespace Headless\Modules\Entities\PostTypes;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Blog
 *
 * Blog Custom Post Type
 */
class Blog extends AbstractPostType {

	/**
	 * Get the post type slug
	 *
	 * @return string
	 */
	protected function get_slug(): string {
		return 'blog';
	}

	/**
	 * Get the singular label
	 *
	 * @return string
	 */
	protected function get_singular_label(): string {
		return 'Blog Post';
	}

	/**
	 * Get the plural label
	 *
	 * @return string
	 */
	protected function get_plural_label(): string {
		return 'Blog Posts';
	}

	/**
	 * Get the custom arguments
	 *
	 * @return array
	 */
	protected function get_custom_args(): array {
		return [
			'supports' => [ 'title', 'editor', 'thumbnail', 'excerpt' ],
			'template' => [
				[
					'acf-block/blog-article',
					[], // block attributes
					[   // inner blocks
						[ 'core/paragraph' ],
						[ 'core/footnotes' ]
					]
				]
			]
		];
	}
}