<?php
declare( strict_types=1 );

namespace Headless\Modules\Entities;

use Headless\Interfaces\Registrable;
use Headless\Traits\Loadable;
use Headless\Modules\Entities\Defaults\DefaultPostTypes;
use Headless\Modules\Entities\Defaults\DefaultTaxonomies;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class EntitiesManager
 *
 * Central registry for managing custom post types and taxonomies
 * Responsible for maintaining the list of entities and coordinating their registration with WordPress
 */
class EntitiesManager implements Registrable {
	use Loadable;

	/**
	 * List of registered entities
	 *
	 * @var array
	 */
	protected array $entities = [
		// PostTypes\Blog::class	
	];

	/**
	 * Register the entities' manager
	 *
	 * @return void
	 */
	public function register(): void {

		// Register entities
		$this->register_entities();

		// Modify default taxonomies
		DefaultTaxonomies::modify();

		// Modify default post types
		DefaultPostTypes::modify();
	}

	/**
	 * Register all loaded entities with WordPress
	 *
	 * @return void
	 */
	private function register_entities(): void {
		foreach ( $this->entities as $entity_class ) {
			if ( class_exists( $entity_class ) ) {
				$entity = new $entity_class();
				if ( method_exists( $entity, 'register' ) ) {
					add_action( 'init', [ $entity, 'register' ] );
				}
			}
		}
	}

}

EntitiesManager::load();
