<?php
declare( strict_types=1 );

namespace Headless\Modules\Entities\Defaults;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class DefaultPostTypes
 *
 * Modifies default post types
 */
class DefaultPostTypes {

	/**
	 * Modify default post types
	 *
	 * This method is used to modify default post types
	 *
	 * @return void
	 */
	public static function modify(): void {

		add_filter( 'register_post_type_args', function ( $args, $post_type ) {
			/**
			 * Modify the default post type
			 *
			 * @var array $args The post type settings
			 * @var string $post_type The post type name
			 */
			// if ( $post_type === 'post' ) {

			// 	$args['public'] = false;
			// 	$args['show_ui'] = false;
			// 	$args['show_in_menu'] = false;
			// 	$args['show_in_rest'] = false;
			// }

			return $args;
		}, 10, 2 );
	}
}
